return Def.ActorFrame{
	-- Decorative stuff underneath.
	LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
		OnCommand=function(self)
			self:y((-(_screen.cy*0.9)/2)-20):zoomto(_screen.w,16):rotationz(1):diffuse(Color.Black)
		end
	},
	LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
		OnCommand=function(self)
			self:y(((_screen.cy*0.9)/2)+20):zoomto(_screen.w,16):rotationz(1):diffuse(Color.Black)
		end
	},

	-- Base.
	Def.Quad{
		OnCommand=function(self)
			self:zoomto(_screen.w*1.2,_screen.cy*0.9):diffuse(LocalBlueColor(0))
		end
	},
	
	-- Top edge.
	Def.Quad{
		OnCommand=function(self)
			self:y(-(_screen.cy*0.9)/2):zoomto(_screen.w*1.2,36):diffuse(LocalBlueColor(0.5)):rotationz(-1)
		end
	},
	LoadActor(THEME:GetPathB("_common", "nextscroll")) .. {
		InitCommand=cmd(y,(-(_screen.cy*0.9)/2)+27;zoomto,_screen.w,128;customtexturerect,0,0,2.75,1;texcoordvelocity,0.3,0;rotationz,-1;diffuse,LocalBlueColor(0.5);blend,Blend.Add)
	},
	LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
		OnCommand=function(self)
			self:y((-(_screen.cy*0.9)/2)-18):zoomto(_screen.w,16):rotationz(-1):blend(Blend.Add)
		end
	},
	LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
		OnCommand=function(self)
			self:y((-(_screen.cy*0.9)/2)+18):zoomto(_screen.w,16):rotationz(-1):blend(Blend.Add)
		end
	},
	
	-- Bottom edge.
	Def.Quad{
		OnCommand=function(self)
			self:y((_screen.cy*0.9)/2):zoomto(_screen.w*1.2,36):diffuse(LocalBlueColor(0.5)):rotationz(-1)
		end
	},
	LoadActor(THEME:GetPathB("_common", "nextscroll")) .. {
		InitCommand=cmd(y,((_screen.cy*0.9)/2)+27;zoomto,_screen.w,128;customtexturerect,0,0,2.75,1;texcoordvelocity,0.3,0;rotationz,-1;diffuse,LocalBlueColor(0.5);blend,Blend.Add)
	},
	LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
		OnCommand=function(self)
			self:y(((_screen.cy*0.9)/2)-18):zoomto(_screen.w,16):rotationz(-1):blend(Blend.Add)
		end
	},
	LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
		OnCommand=function(self)
			self:y(((_screen.cy*0.9)/2)+18):zoomto(_screen.w,16):rotationz(-1):blend(Blend.Add)
		end
	},
	
	-- Tag behind stage number.
	LoadActor("_stagetag") .. {
		OnCommand=cmd(horizalign,left;x,(-_screen.cx)+40;y,-(_screen.cy*0.9)/2)
	},
	
	-- Stage number (eventually).
	Def.BitmapText {
		Font = "Common Normal",
		OnCommand=function(self)
			self:uppercase(true):xy((-_screen.cx)+70,(-(_screen.cy*0.9)/2)-10):horizalign(left):vertalign(top):zoom(0.75):strokecolor(Color.Black):maxwidth(370/0.75)
			
			self:settext(StageToLocalizedString(GAMESTATE:GetCurrentStage()))
		end
	},
	
	-- Jacket frame.
	LoadActor(THEME:GetPathB("", "ScreenGameplay overlay/jacketFrame")) .. {
		OnCommand=function(self)
			self:x((-_screen.cx)+90)
		end
	},
	-- Jacket itself.
	Def.Sprite {
		OnCommand=function(self)
			local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
			
			if target then
				self:LoadBanner(target:GetJacketOrSubstitutePath())
			else
				self:LoadBanner(THEME:GetPathG("Common","fallback jacket"))
			end
			self:scaletoclipped(140,140):x((-_screen.cx)+90)
		end
	},
	
	-- Song name
	Def.BitmapText{
		Font = "Common Normal",
		OnCommand = function(self)
			local target = GAMESTATE:IsCourseMode() and GAMESTATE:GetCurrentCourse() or GAMESTATE:GetCurrentSong()
			
			if target then
				-- Make this check because the way we'll get our needed strings is
				-- a little different when we're dealing with courses
				if GAMESTATE:IsCourseMode() then
					if target:GetDescription() ~= "" then
						self:settext(target:GetDisplayFullTitle() .. "\n'" .. target:GetDescription() .. "'")
					else
						self:settext(target:GetDisplayFullTitle())
					end
				else
					self:settext(target:FormattedSongTitleAndArtist())
				end
			end
			
			self:x(65):maxwidth((_screen.w-150)/0.75):wrapwidthpixels((_screen.w-150)/0.75):
				strokecolor(Color.Outline):zoom(0.75)
		end
	},
	
	-- Parapara metadata.
	Def.BitmapText{
		Font = "Common Normal",
		OnCommand = function(self)
			if GAMESTATE:IsCourseMode() then return end -- IT'S NO USE!!11
			local pmIni = GAMESTATE:GetCurrentSong():GetParamaniaIni()
			
			local lowestDifficulty = GAMESTATE:GetEasiestStepsDifficulty()
			local hardestDifficulty = GAMESTATE:GetHardestStepsDifficulty()
			
			if GAMESTATE:GetCurrentGame():GetName() ~= "para" or Enum.Compare(Difficulty, lowestDifficulty, Difficulty[2]) > 0 then
				self:settext((pmIni.Metadata.FreestyleVJ and pmIni.Metadata.FreestyleVJ ~= "") and "\nVJ: " .. pmIni.Metadata.FreestyleVJ or "")
			else
				local danC = (lowestDifficulty == Difficulty[2] and pmIni.Metadata.AltDancers and pmIni.Metadata.AltDancers ~= "") and pmIni.Metadata.AltDancers or pmIni.Metadata.Dancers
				local cHo = (lowestDifficulty == Difficulty[2] and pmIni.Metadata.AltChoreo and pmIni.Metadata.AltChoreo ~= "") and pmIni.Metadata.AltChoreo or pmIni.Metadata.Choreo
				
				self:settext(THEME:GetString("Misc", "MdDancer") .. ": " .. danC .. "\n" .. THEME:GetString("Misc", "MdChoreo") .. ": " .. cHo)
			end
			
			self:xy(_screen.cx-20,-(_screen.h/3)+20):zoom(0.4):horizalign(right):vertalign(bottom):strokecolor(Color.Outline):maxwidth((_screen.w-40)/0.4)
		end
	}
}